document.addEventListener("DOMContentLoaded", () => {
    const music = document.getElementById('background-music');
    const musicBtn = document.getElementById('music-button');
  
    if (localStorage.getItem('musicPlaying') === 'true') {
      music.play();
      musicBtn.innerHTML = '<i class="fas fa-volume-up"></i>';
    } else {
      musicBtn.innerHTML = '<i class="fas fa-volume-mute"></i>';
    }
  
    musicBtn.addEventListener('click', () => {
      if (music.paused) {
        music.play();
        localStorage.setItem('musicPlaying', 'true');
        musicBtn.innerHTML = '<i class="fas fa-volume-up"></i>';
      } else {
        music.pause();
        localStorage.setItem('musicPlaying', 'false');
        musicBtn.innerHTML = '<i class="fas fa-volume-mute"></i>';
      }
    });
  });
  